#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Configuração centralizada de versão do FastChecker II
Garante consistência entre todos os módulos
"""

# Versão principal do software
SOFTWARE_VERSION = "2.0.0"

# Informações adicionais do software
SOFTWARE_NAME = "FastChecker II"
SOFTWARE_FULL_NAME = f"{SOFTWARE_NAME} v{SOFTWARE_VERSION}"

# Função para obter informações completas do software
def get_software_info():
    """
    Retorna informações completas do software
    
    Returns:
        dict: Dicionário com informações do software
    """
    return {
        'name': SOFTWARE_NAME,
        'version': SOFTWARE_VERSION,
        'full_name': SOFTWARE_FULL_NAME,
        'software': SOFTWARE_VERSION  # Para compatibilidade com código existente
    }

# Função para obter apenas a versão (para compatibilidade)
def get_version():
    """
    Retorna apenas a versão do software
    
    Returns:
        str: Versão do software
    """
    return SOFTWARE_VERSION

# Função para obter apenas o nome completo (para compatibilidade)
def get_full_name():
    """
    Retorna o nome completo do software com versão
    
    Returns:
        str: Nome completo do software
    """
    return SOFTWARE_FULL_NAME

